<!-- Page Heading -->
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Venta Diaria</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="/Botica/views/compras/js/jquery.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/compras/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function obtenerNumeroCorrelativo() {
            var tipo = document.getElementById("tipo_cpe").value;
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/Botica/views/ventas/mostrar_comprobantes.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    // Actualizar el valor del campo de texto con el resultado recibido
                    document.getElementById("numero_correlativo").value = xhr.responseText;
                } else {
                    document.getElementById("numero_correlativo").value = "Error al obtener el número.";
                }
            };
            xhr.send("tipo_cpe=" + encodeURIComponent(tipo));
        }
    </script>
    <script type="text/javascript">
        $(document).ready(function () {
            //$('#ruc_num').val('RUC');
            //$('#tipo_doc').val('DNI');
            $('#tipo_doc').val('LQ');
        })
    </script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #3e64d3;
            text-align: left;
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <script>
        // Cambiar color al enfocar
        function changeColor(element, color) {
            element.style.backgroundColor = color;
        }
        // Restaurar color al salir
        function resetColor(element) {
            element.style.backgroundColor = '';
        }
    </script>
</head>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Nueva compra</h1>
</div>

<div class="card mb-1">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <div class="input-group mb-3">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" id="dni" autocomplete="off" name="dni" autofocus="autofocus" style="width:150px;"
                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                    <button id="prueba" class="btn btn-primary" name="prueba">Buscar DNI</button>
                </div>
                <div style="display: none"><b> DNI : </b><label for="dniNumero" id="dniNumero"></label></div>
                <div style="display: none"><b> Nombres : </b><label for="nombre" id="nombre"></label></div>
                <div style="display: none"><b> Apellido P. : </b><label for="apellidop" id="apellidop"></label>
                </div>
                <div style="display: none"><b> Apellido M. : </b><label for="apellidom" id="apellidom"></label>
                </div>
                <script>
                    $("#prueba").click(function () {
                        var dni = $("#dni").val();
                        $.ajax({
                            type: "POST",
                            url: "/Botica/views/compras/consulta-dni-ajax.php",
                            data: 'dni=' + dni,
                            dataType: 'json',
                            success: function (data) {
                                if (data == 1) {
                                    alert('El DNI tiene que tener 8 digitos');
                                }
                                else {
                                    console.log(data);
                                    numeroDocumento = data.numeroDocumento;
                                    nombres = data.nombres;
                                    apellidoPaterno = data.apellidoPaterno;
                                    apellidoMaterno = data.apellidoMaterno;
                                    $("#dniNumero").html(data.numeroDocumento);
                                    $("#nombre").html(data.nombres);
                                    $("#apellidop").html(data.apellidoPaterno);
                                    $("#apellidom").html(data.apellidoMaterno);
                                    $("#dniNumeroInput").val(data.numeroDocumento);
                                    $("#nombre-proveedor").val(data.nombre);
                                    $("#dir-proveedor").val(data.direccion);
                                    $('#numdoc').val(data.numeroDocumento);
                                }
                            }
                        });
                    })
                </script>
            </div>
            <div class="col-md-4">
                <div class="input-group mb-3">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" autocomplete="off" id="ruc" name="ruc" style="width:150px;"
                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                    <button id="pruebaruc" class="btn btn-secondary ">Buscar RUC</button>
                </div>
                <div style="display: none" display: none"><b> RUC : </b><label id="rucNumero"></label></div>
                <div style="display: none" display: none"><b> Razón social: </b><label id="razonsocial"></label></div>
                <div style="display: none" display: none"><b> Estado: </b><label id="estado"></label></div>
                <div style="display: none" display: none"><b> Dirección: </b><label id="direccion"></label></div>
                <div style="display: none" display: none"><b> Departamento: </b><label id="departamento"></label>
                </div>
                <script>
                    $("#pruebaruc").click(function () {
                        var ruc = $("#ruc").val();
                        $.ajax({
                            type: "POST",
                            url: "/Botica/views/compras/consultar-ruc-ajax.php",
                            data: 'ruc=' + ruc,
                            dataType: 'json',
                            success: function (data) {
                                if (data == 1) {
                                    alert('El RUC tiene que tener 11 digitos');
                                }
                                else {
                                    console.log(data);
                                    $("#rucNumero").html(data.numeroDocumento);
                                    $("#razonsocial").html(data.nombre);
                                    $("#estado").html(data.estado);
                                    $("#direccion").html(data.direccion);
                                    $("#departamento").html(data.departamento);
                                    $("#rucNumeroInput").val(data.numeroDocumento);
                                    $("#nombre-proveedor").val(data.nombre);
                                    $("#dir-proveedor").val(data.direccion);
                                    $("#dniNumeroInput").val(data.numeroDocumento);
                                    $("#nombre-proveedor").val(data.nombre);
                                    $("#dir-proveedor").val(data.direccion);
                                }
                            }
                        });
                    })
                </script>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-5">
        <div class="card">
            <div class="card-body">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                    </div>
                    <input type="text" class="form-control" placeholder="Barcode" id="seacrh"
                        onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                </div>
                <div class="table-responsive">
                    <table class="table" id="table_temp" style="width: 100%;">
                        <thead class="table-dark table-bordered">
                            <tr>
                                <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">
                                    Producto</th>
                                <th scope="col">Precio</th>
                                <th scope="col">Cantidad</th>
                                <th scope="col">SubTotal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-between">
                    <h5>Datos del proveedor</h5>
                    <button class="btn btn-info" data-toggle="modal" data-target="#modal-proveedor"><i
                            class="fas fa-search"></i> Proveedor</button>
                </div>
                <hr>
                <div class="card-body">
                    <div class="row">
                        <input type="text" id="id-proveedor" value="1">
                        <div class="col-md-4">
                            <div class="input-group mb-3">
                                <input style="width:80px;" type="text" class="form-control" id="dniNumeroInput"
                                    name="dniNumeroInput" placeholder="DNI/RUC" style="width: 225px; font-size:14px;"
                                    onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="input-group mb-1">
                                <input type="text" class="form-control" id="nombre-proveedor" placeholder="Nombre"
                                    style="width: 300px; font-size:14px;" onfocus="changeColor(this, '#f7f201')"
                                    onblur="resetColor(this)">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="input-group mb-3">
                                <input type="text" class="form-control" id="dir-proveedor" placeholder="Dirección"
                                    onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <select id="tipo_doc" name="tipo_doc" class="form-control"
                                style="cursor:pointer; width: 182px; font-size:14px;"
                                onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)">
                                <option value="FA">FACTURA</option>
                                <option value="LQ">LIQUIDACION COMPRA</option>
                                <option value="BV">BOLETA</option>
                                <option value="BV">GUIA REMISION</option>
                                <option value="BV">ORDEN DE COMPRA</option>
                            </select>
                            <input type="text" class="form-control" id="num_doc" placeholder="Numero Documento"
                                style="width: 182px; font-size:16px;" onfocus="changeColor(this, '#f7f201')"
                                onblur="resetColor(this)">
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="col-md-4">
                            <button type="button" class="btn btn-primary btn-block" id="btn-guardar"><i
                                    class="fas fa-save"></i> Guardar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-7">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table" id="table_compra" style="width: 100%;">
                                <thead class="thead-dark">
                                    <tr>
                                        <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;"
                                            scope="col">Código</th>
                                        <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;"
                                            scope="col">Producto</th>
                                        <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;"
                                            scope="col">Stock</th>
                                        <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;"
                                            scope="col">Precio</th>
                                        <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;">Accion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="modal-proveedor" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Seleccionar proveedor</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table" id="table_proveedores" style="width: 100%;">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">Proveedor</th>
                                <th scope="col">Telefono</th>
                                <th scope="col">Direccion</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</html>